//
//  GSUtil.h
//  Webcast
//
//  Created by jiangcj on 16/1/27.
//  Copyright © 2016年 Geensee. All rights reserved.
//

#import <UIKit/UIKit.h>


#define UIScreenWidth  [[UIScreen mainScreen] bounds].size.width

#define UIScreenHeight  [[UIScreen mainScreen] bounds].size.height


#define GSCurrentWindow [[UIApplication sharedApplication].windows firstObject]











typedef NS_ENUM(NSUInteger,LanguageType){
    /**
     *简体
     */
    SimChineseType=1,
    
    /**
     *繁体
     */
    TraChineseType,
    
    
    /**
     *英文
     */
    EnglishType,
    
    /**
     *其他语言
     */
    OtherLangType,
    

    
};





#define GNSLocalizedString(key, comment) \
 [GSUtil GSLocalizedString:key value:comment]



#define kCurrentWindow [UIApplication sharedApplication].keyWindow

@interface GSUtil : NSObject

/*
 中文,英文,繁体
 */
+(LanguageType)getLangTypePreferredLanguage;



+ (NSString *)GSLocalizedString:(NSString *)translation_key value:(NSString*)value;





+(CGSize)getSizeWithContentAndFontBy8character:(CGFloat)fontSize;



+(CGSize)getSizeWithContentAndFont:(NSString*)content fontSize:(CGFloat)fontSize;


+(CGSize)getSizeWithContentAndFont:(NSString*)content fontSize:(CGFloat)fontSize  constraint:(CGSize)constraint;



+(CGSize)getSizeWithContentAndFont:(NSString*)content UIFont:(UIFont*)uifont  constraint:(CGSize)constraint;



+(NSString*)convertTimeToStr:(unsigned int)currentTime;


+(NSString*)getCurrentAppleDevice;


+(UIImage*)resizeStretchImage:(UIEdgeInsets)insets image:(UIImage*)image;



+(NSString*)timeIntervalToStr:(long)timeInterval;


+(NSString*)timeIntervalToStrSec:(long)timeInterval;



+(NSString*)substringToIndexLength:(NSString*)str length:(int)length;


+(NSString*)substringToIndexAllLength:(NSString*)str length:(int)length;




//for hong bao
+(NSString*)setupChangeNameForSpecifiedLength:(NSString*)strIn   fontSize:(CGFloat)fontSize;


/*
 指定宽度，获得相等长度的字符串,指定字符数的个数
 */

+(NSString*)setupChangeNameForSpecifiedLength:(NSString*)strIn   fontSize:(CGFloat)fontSize  num:(int)num;






+(UIImage*)getImageByRetina:(NSString*)imageName;


+(UIImage *)scaleAndRotateImage:(UIImage *)image;



+(NSData*) hexToBytes:(NSString*)pngStr ;

+ (UIViewController *)presentViewController;


+ (NSBundle *)resourceGLiveSDKBundle;

//获取最上层ViewController
+ (UIViewController *)getViewController;

@end
